setwd("F:\\Wokspace\\C19\\SDL\\Step2\\Pandemia0.25Test\\data\\traces")
nameFile <-c("Pandemia (2020-04-10 1859h)")
require(XML)
data <-xmlParse("Pandemia (2020-04-10 1859h).trace.xml")
xTime <-xpathSApply(data, "//Events/EYE_Report/@xTime")
agent <-xpathSApply(data, "//Events/EYE_Report/@agent")
varname <-xpathSApply(data, "//Events/EYE_Report/@varname")
vartype <-xpathSApply(data, "//Events/EYE_Report/@vartype")
varvalue <-xpathSApply(data, "//Events/EYE_Report/@varvalue")
label <-xpathSApply(data, "//Events/EYE_Report/@label")
report_values<-data.frame(xTime, agent, varname, vartype, varvalue, label)
xTime_array <-xpathSApply(data, "//Events/EYE_ReportArray/@xTime")
agent_array <-xpathSApply(data, "//Events/EYE_ReportArray/@agent")
varname_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varname")
vartype_array <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype")
varvalue_array <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue")
label_array <-xpathSApply(data, "//Events/EYE_ReportArray/@label")
varname_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varname_label")
vartype_label <-xpathSApply(data, "//Events/EYE_ReportArray/@vartype_label")
varvalue_label <-xpathSApply(data, "//Events/EYE_ReportArray/@varvalue_label")
report_array_values<-data.frame(xTime_array, agent_array, varname_label, vartype_label, varvalue_label, varname_array, vartype_array, varvalue_array, label_array)

totalInfective = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalInfective"]))
totalInfectivexTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalInfective"]))
totalDeceased = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalDeceased"]))
totalDeceasedxTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalDeceased"]))
susceptible = as.numeric(as.character(report_values$varvalue[report_values$varname=="susceptible"]))
susceptiblexTime = as.numeric(as.character(report_values$xTime[report_values$varname=="susceptible"]))
totalRecovered = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalRecovered"]))
totalRecoveredxTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalRecovered"]))
totalExposed = as.numeric(as.character(report_values$varvalue[report_values$varname=="totalExposed"]))
totalExposedxTime = as.numeric(as.character(report_values$xTime[report_values$varname=="totalExposed"]))



path<-getwd()
dataPath <- paste(path,"\\..\\insightmaker.csv",sep="")
insightMaker<- read.csv2(dataPath, header = TRUE, sep = ",", dec=".", stringsAsFactors=FALSE)



library('plotly')
library('htmlwidgets')



#############################################  susceptible   #############################################

path<-getwd()
x <- c(1:length(susceptible))
data <- data.frame(x, susceptible)

insightData<-insightMaker$Susceptible[x]

grafica1 <- plot_ly(data, x = ~x, y = ~susceptible, type = 'scatter', mode = 'lines', name='Susceptible SDL')
grafica1 <- grafica1 %>% add_trace(y = ~insightData, name = 'Susceptible Insight', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "susceptible.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################


#############################################  totalInfective   #############################################

path<-getwd()
x <- c(1:length(totalInfective))
data <- data.frame(x, totalInfective)
insightData<-insightMaker$Infective[x]

grafica1 <- plot_ly(data, x = ~x, y = ~totalInfective, type = 'scatter', mode = 'lines', name='Infective SDL')
grafica1 <- grafica1 %>% add_trace(y = ~insightData, name = 'Infective InisghtMaker', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "totalInfective.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)


#############################################################################################################


#############################################  newExposed   #############################################

# x <- c(1:length(newExposed))
# data <- data.frame(x, newExposed)
# 
# #insightData<-insightMaker$Exposed[x]
# 
# grafica1 <- plot_ly(data, x = ~x, y = ~newExposed, type = 'scatter', mode = 'lines', name='Exposed SDL')
# #grafica1 <- grafica1 %>% add_trace(y = ~insightData, name = 'Exposed Insight', line = list(color = 'rgb(22, 96, 167)', width = 4)) 
# 
# 
# grafica <- "newExposed.html"
# 
# htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################



#############################################  totalDeceased   #############################################

path<-getwd()
x <- c(1:length(totalDeceased))
data <- data.frame(x, totalDeceased)


insightData<-insightMaker$Death[x]

grafica1 <- plot_ly(data, x = ~x, y = ~totalDeceased, type = 'scatter', mode = 'lines', name='Deceased SDL')
grafica1 <- grafica1 %>% add_trace(y = ~insightData, name = 'Deceased Insight', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "totalDeceased.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################

#############################################  totalRecovered   #############################################

path<-getwd()
x <- c(1:length(totalRecovered))
data <- data.frame(x, totalRecovered)

insightData<-insightMaker$Recovered[x]

grafica1 <- plot_ly(data, x = ~x, y = ~totalRecovered, type = 'scatter', mode = 'lines', name='Recover SDL')
grafica1 <- grafica1 %>% add_trace(y = ~insightData, name = 'Recover Insight', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "totalRecovered.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################


#############################################  totalExposed   #############################################

path<-getwd()
x <- c(1:length(totalExposed))
data <- data.frame(x, totalExposed)

insightData<-insightMaker$Exposed[x]

grafica1 <- plot_ly(data, x = ~x, y = ~totalExposed, type = 'scatter', mode = 'lines', name='Exposed SDL')
grafica1 <- grafica1 %>% add_trace(y = ~insightData, name = 'Exposed Insight', line = list(color = 'rgb(22, 96, 167)', width = 4)) 

grafica <- "totalExposed.html"

htmlwidgets::saveWidget(as.widget(grafica1), grafica,selfcontained = FALSE)

#############################################################################################################
